/* ============ */
/* RunTst.c	*/
/* ============ */
#include <math.h>
#include <miscdefs.h>
#include <rundefs.h>
#include <mconf.h>
#include <stdio.h>
#include <stdlib.h>

#define SQR(X)	((X) * (X))

#define	FULL_SIZE  ((unsigned)RAND_MAX + 1U)
int	RandNums[FULL_SIZE];
double	ChiSqProb[NUM_PROBS];

/* ==================================================================== */
/* main - Performs Runs-Up Test per Knuth Vol. 2, p. 74, Ex. 12 & 14	*/
/* ==================================================================== */
void
main()
{
    INIT_DATA_STRU InitialData;
    RUN_DATA_STRU RunData;
    double  KnMinusStat, KnMinusProb, KnPlusStat, KnPlusProb;

    AbortGracefully();			/* Cause ^C to Behave */

    printf("\n\t\tR U N  T E S T\n\n");
    GetInitialData(&InitialData);
    /* -------------------------- */
    /* Print Initial Data Entries */
    /* -------------------------- */
    printf("\nStarting Seed = %u%s\n", InitialData.UserSeed,
	(InitialData.SeedSrce == (UINT) (-1)) ?
	" (Unsigned Integer Part of Time of Day)" : "");
    printf("Generator     = %s\n", InitialData.GenName);

    RunData.RandFun = InitialData.RandFun;
    RunData.RandArray = RandNums;
    RunData.ChiSqProb = ChiSqProb;

    SetRunControls(&RunData);

    GenerateChiSquareData(&RunData);

    if (RunData.CallStatus == TRUE)
    {
	/* -------------------------------------------------------- */
	/* Calculate K-S on Chi-Square Statistics and Probabilities */
	/* -------------------------------------------------------- */
	fflush(NULL);
	KSCalc(ChiSqProb, NUM_PROBS,
	    &KnPlusStat, &KnPlusProb,
	    &KnMinusStat, &KnMinusProb);

	printf("\nKolmogorov-Smirnov Statistics and Probabilities"
	    " on Chi-Square Data\n");

	printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", NUM_PROBS,
	    sqrt((double) NUM_PROBS) * KnPlusStat, 100 * KnPlusProb);

	printf("\tK(%d)- = %f (Knuth) or %9f%%\n", NUM_PROBS,
	    sqrt((double) NUM_PROBS) * KnMinusStat, 100 * KnMinusProb);
    }

    printf("\nThis Run Required %ld Random Numbers\n\n",
	RunData.TotVariates);
}
